"""
HB_ZoomCamera V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.

Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_ZoomCamera

Description-US: Creates a ZoomCamera and resets view to Scene Camera

Usage:
First usage will Create a Camera "HB_ZoomCamera" which is below your Scenecamera. 
Now you can use Film-Offset and Film-Zoom Tools to frame a part of the image without changing perspective.
When you use the Script now (with HB_ZoomCamera already created) it will reset you view to the original Scene-Camera.

Video Tutorial:
https://youtu.be/G9XVCcOe6jQ?t=12m30s


ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d
from c4d import gui

def ResetCam(ZoomCam,RootCam):
    ZoomCam.SetMg(RootCam.GetMg())
    ZoomCam[c4d.CAMERA_FOCUS]=RootCam[c4d.CAMERA_FOCUS]
    ZoomCam[c4d.CAMERAOBJECT_APERTURE]=RootCam[c4d.CAMERAOBJECT_APERTURE]
    ZoomCam[c4d.CAMERAOBJECT_FILM_OFFSET_X]=RootCam[c4d.CAMERAOBJECT_FILM_OFFSET_X]
    ZoomCam[c4d.CAMERAOBJECT_FILM_OFFSET_Y]=RootCam[c4d.CAMERAOBJECT_FILM_OFFSET_Y]
    return ZoomCam

def main():
    doc.StartUndo()
    bd = doc.GetActiveBaseDraw()
    mysettings_bc=c4d.BaseContainer()
    bc = c4d.BaseContainer()
    EditorCam = bd.GetEditorCamera()

    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):
        
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 :
           
                Camera=doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]
                if Camera == EditorCam:
                    ZoomCamera=c4d.BaseObject(c4d.Ocamera)
                    ZoomCamera.SetName("HB_ZoomCamera")
                    doc.AddUndo(c4d.UNDOTYPE_NEW, ZoomCamera)
                    doc.InsertObject(ZoomCamera, None)
                    ResetCam(ZoomCamera, EditorCam)
                    doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=ZoomCamera
                
                    c4d.EventAdd()
                    gui.MessageDialog("You are now looking through HB_ZoomCamera")
                    return
                   

                
                
                CamName=Camera.GetName()
                if CamName == "HB_ZoomCamera":
                    RootCam=Camera.GetUp()
                    ResetCam(Camera, RootCam)
                else:
                    
                    ZoomCamera=c4d.BaseObject(c4d.Ocamera)
                    ZoomCamera.SetName("HB_ZoomCamera")
                    doc.AddUndo(c4d.UNDOTYPE_NEW, ZoomCamera)
                    ZoomCamera.InsertUnder(Camera)
                    ResetCam(ZoomCamera, Camera)
                    doc.GetActiveBaseDraw()[c4d.BASEDRAW_DATA_CAMERA]=ZoomCamera
                    
                    gui.MessageDialog("You are now looking through HB_ZoomCamera")
        
                    

        if bc[c4d.BFM_INPUT_QUALIFIER] ==4 : #ALT modifier
            print "ALT pressed"
            

    c4d.EventAdd()
    

if __name__=='__main__':
    main()
